#delimit ;
local gallup_vars 
    wp4 wp5 wp5aa wgt wp1219 wp1220 wp1223 wp1225 wp22 wp68 wp1223 
    wp14 wp3117 wp16 wp17 wp18 wp4656  wp59 wp60 wp61 wp62 
    wp63 wp64 wp65 wp66 wp67 wp68 wp69 wp70 wp71 wp72 wp73
    wp74 wp76 
	wp10233 wp10235 wp10266 wp1418 wp6878  
	wp30 wp134 wp1325
	wp21
	wp12 wp1230
    inc_* wp7824 field_date wave year_wave year_calendar;
#delimit cr

use `gallup_vars' using "E:\Users\jwolfers\Documents\Justin@Wharton\Gallup World Poll\the_gallup_012513.dta" if field_date>=mdy(1,1,2008), clear
rename wave wave_old
rename year_wave wave
gen wt=wgt
la var wt "Weight for individual analysis"
gen wt_cty=wgt
la var wt_cty "Appropriate weight for national analyses"
gen str3 cty=""
qui for ! in num 1 2 3 4 5 6 8 9 \ @ in any USA EGY MAR LBN SAU JOR TUR PAK: replace cty="@" if wp5==!
qui for ! in num 10/19 \ @ in any IDN BGD GBR FRA DEU NLD BEL ESP ITA POL: replace cty="@" if wp5==!
qui for ! in num 20/29 \ @ in any HUN CZE ROM SWE GRC DNK IRN HKG SGP JPN: replace cty="@" if wp5==!
qui for ! in num 30/39 \ @ in any CHN IND VEN BRA MEX NGA KEN TZA ISR PSE: replace cty="@" if wp5==!
qui for ! in num 40/49 \ @ in any GHA UGA BEN MDG MWI ZAF CAN AUS PHL LKA: replace cty="@" if wp5==!
qui for ! in num 50/57 \ @ in any VNM THA KHM LAO MMR NZL AGO BWA: replace cty="@" if wp5==!
qui for ! in num 60/69 \ @ in any ETH MLI MRT MOZ NER RWA SEN ZMB KOR TWN: replace cty="@" if wp5==!
qui for ! in num 70/79 \ @ in any AFG BLR GEO KAZ KGZ MDA RUS UKR BFA CMR: replace cty="@" if wp5==!
qui for ! in num 80 81 82 83 84 87 88 89 \ @ in any SLE ZWE CRI ALB DZA ARG ARM AUT: replace cty="@" if wp5==!
qui for ! in num 90 96 97 99 \ @ in any AZE BOL BIH BGR: replace cty="@" if wp5==!
qui for ! in num 100 103 104 105 109 \ @ in any BDI TCD CHL COL HRV: replace cty="@" if wp5==!
qui for ! in num 110 111 114 115 116 119 \ @ in any CUB CYP DOM ECU SLV EST: replace cty="@" if wp5==!
qui for ! in num 121 124 128 129 \ @ in any FIN GTM HTI HND: replace cty="@" if wp5==!
qui for ! in num 131 132 135 137 138 \ @ in any IRQ IRL JAM KWT LVA: replace cty="@" if wp5==!
qui for ! in num 143 145 146 \ @ in any LTU MKD MYS: replace cty="@" if wp5==!
qui for ! in num 154 157 158 \ @ in any MNE NPL NIC: replace cty="@" if wp5==!
qui for ! in num 160 163 164 165 166 167 \ @ in any NOR PAN PRY PER PRT PRI: replace cty="@" if wp5==!
qui for ! in num 173 175 176 \ @ in any SRB SVK SVN: replace cty="@" if wp5==!
qui for ! in num 184 185 187 189 \ @ in any CHE TJK TGO TTO: replace cty="@" if wp5==!
qui for ! in num 193 194 195 197 198 \ @ in any ARE URY UZB YEM UNK: replace cty="@" if wp5==! /* Note Kosovo is UNK */
qui for ! in num 94 102 107 125 127 140 153 155 181 190 \ @ in any BLZ CAF COD GIN GUY LBR MNG NAM SDN TUN: replace cty="@" if wp5==!
qui for ! in num 7 108 112 \ @ in any SYR COG DJI: replace cty="@" if wp5==!
qui for ! in num 92 106 130 134 144 148 168 191 \ @ in any BHR COM ISL CIV LUX MLT QAT TKM: replace cty="@" if wp5==!
qui for ! in num 141 150 \ @ in any LBY MUS: replace cty="@" if wp5==!
qui for ! in num 122 139 161 183 \ @ in any GAB LSO OMN SWZ: replace cty="@" if wp5==!
replace cty="SOM" if wp5==199 /* This coding for Somaliland, which is an autonomous region in Somalia, as Somalia */
replace cty="TNC" if wp5==202 /* This is for the Turkish Republic of North Cyprus, is a self-declared state in Northern Cyprus, recognized only by Turkey, but not EU */
tab wp5 if cty==""
assert missing(wp5) if missing(cty)
rename wp5 gallup_countrycodes
rename wp5aa country_gallup
rename wp4 date_interview
rename year_calendar year
gen oecd=0
for X in any AUT BEL CAN DNK FRA DEU GRC ISL IRL ITA LUX NLD NOR PRT ESP SWE CHE TUR GBR USA JPN FIN AUS NZL MEX CZE KOR HUN POL SVK: replace oecd=1 if cty=="X"


rename wp1219 sex
rename wp1220 age
replace age=. if age==100
gen agegroup=.
for X in num 15 30 45 60 \ Y in num 29 44 59 99: replace agegroup=X if age>=X & age<=Y
label define agegroup 15 "15 to 29" 30 "30 to 44" 45 "45 to 59" 60 "60 plus"
label values agegroup agegroup
la var agegroup "Age"
rename wp1223 marital
recode marital (6 7= .)
rename wp14 urbanruralcity
recode urbanruralcity (4 5 = .)
rename wp3117 educ
recode educ (4 5 = .)
la var educ "Education"
rename wp1225 occupation
recode occupation (13 14 = .)
rename wp12 hhsize
recode hhsize (97 98 99 = .)
rename wp1230 kids
recode kids (98 99 =.)

rename wp16 sat_current
la var sat_current "Satisfaction Ladder"
rename wp17 sat_past
la var sat_past "Life Satisfaction 5 years ago"
rename wp18 sat_future
la var sat_future "Expected Life Satisfaction in 5 years"
rename wp4656 sat_life
la var sat_life "Life Satisfaction"
for var sat_*: recode X (98 99=.)
for X in num 59/66 10266 \ Y in any moredays wellrested respect choose smile proud learn goodfood calm: rename wpX yesterday_Y 
for X in any moredays wellrested respect choose smile proud learn goodfood calm \ Y in any "Would you like to have more days just like yesterday?" "Did you feel well rested yesterday?" "Were you treated with respect all day yesterday?" "Were you able to choose how you spent your time all day?" "Did you smile or laugh a lot yesterday?" "Were you proud of something you did yesterday?" "Did you learn or do something interesting yesterday?" "Did you have good tasting food to eat yesterday?" "Did you feel calm all day yesterday?" : la var yesterday_X "Y" 
for X in num 67/74 76 10235 1418 6878 \ Y in any enjoyment pain worry sadness stress boredom depression anger love energy fear happiness: rename wpX feelings_Y  
for X in any enjoyment pain worry sadness stress boredom depression anger love energy fear happiness \ Y in any "Enjoyment" "Physical Pain" "Worry" "Sadness" "Stress" "Boredom" "Depression" "Anger" "Love" "High energy" "Fear" "Happiness": la var feelings_X "Y"
rename wp10233 likewhatyoudo
la var likewhatyoudo "Do you like what you do each day?"
rename wp1325 immigrate
la var immigrate "Would you like to move permanently to another country?"
rename wp21 purpose
la var purpose "Do you feel your life has an important purpose or meaning?"
rename wp134 freedom_sat
la var freedom_sat "Are you satisfied with your freedom to choose what you do with your life?"
rename wp22 health_sat
la var health_sat "Are you satisfied with your personal health?"
rename wp30 standardofliving_sat
label define yesno 0 "No" 1 "Yes"
for var yesterday* feelings* likewhatyoudo immigrate freedom purpose *_sat: recode X (1=1) (2=0) (3 4=.) \ label values X yesno
label define satbinary 0 "Dissatisfied" 1 "Satisfied"
for X in var *_sat: label values X satbinary

gen ln_inc=ln(inc_001/1000) /* Still need to deal with zero incomes, and a few missing incomes; Currently I drop zeros*/
gen inc=exp(ln_inc)
la var inc "Household income (Gallup; excludes 0's)"
gen quintile_inc=inc_004
la var quintile_inc "Income quintile within each country"
rename wp7824 inc_currency


/* No inc_003...make a new categorical variable */
gen inc_cat=.
replace inc_cat=1 if inc_001 <= 365*2
replace inc_cat=2 if missing(inc_cat) & inc_001 <= 5000
replace inc_cat=3 if missing(inc_cat) & inc_001 <= 15000
replace inc_cat=4 if missing(inc_cat) & inc_001 <= 40000
replace inc_cat=5 if missing(inc_cat) & !missing(inc_001)
label define inc_cat 1 "<=$2/day" 2 "$731-$5k" 3 "$5k-$15k" 4 "$15k-$40k" 5 "$>40k"
label values inc_cat inc_cat
la var inc_cat "Annual Household Income"

/* Merge in macro data */
merge m:1 cty year using "$directory/gdp/Complete_GDP", keep(master match)
assert _merge==3
drop _merge

/* Standardize variables */

foreach v of varlist sat* yesterday* feelings* *_sat likewhatyoudo immigrat freedom purpose {
	qui tab cty if !missing(`v')
	if `r(r)'<20 { /* Drop any questions not asked in at least 20 countries*/
		drop `v'
	}
}

foreach v of any sat yesterday feelings {
	unab `v'_local: `v'_*
	global `v' ``v'_local'
} 

global continuousvars $sat 
global binaryvars $yesterday $feelings likewhatyoudo immigrate purpose freedom_sat health_sat standardofliving_sat

foreach v of global continuousvars {
	qui summ `v' [aw=wt]
	local mean=`r(mean)'
	qui reg `v' i.ctyid i.wave [aw=wt]
	predict `v'_res, residual
	summ `v'_res [aw=wt]
	local sd=`r(sd)'
	gen `v'_z=(`v'-`mean')/`sd'
	char `v'_z[mean] "`mean'"
	char `v'_z[sd] "`sd'"
	local lb: var lab `v'
	la var `v'_z "`lb' (standardized)"
	la var `v' "`lb' (0-10)"
	drop `v'_res
}


compress
save "$directory/Gallup World Poll/Gallup_micro", replace

* Create macro dataset
use "$directory/Gallup World Poll/Gallup_micro", clear

gen n=1 if !missing(sat_current, lgdp)
la var n "sample size"
foreach v of var * { /* Make sure labels being collapsed */
	local l`v': variable label `v'
    if `"`l`v''"' == "" {
 		local l`v' "`v'"
  	}
 }
foreach v of varlist *_z { /*Make sure that characteristics survive being collapsed */
 	local `v'mean: char `v'[mean]
	local `v'sd : char `v'[sd]
}
collapse (mean) $continuousvars $binaryvars *_z inc lgdp pop oecd field_date (count) n [aw=wt], by(cty)
foreach v of var * {
	label var `v' "`l`v''"
}
foreach v of varlist *_z {
	char `v'[mean] "``v'mean'"
	char `v'[sd] "``v'sd'"
}
la data "Gallup World Poll country averages, 2008-2012"
sort cty
compress
save "$directory\Gallup World Poll\Gallup_macro", replace




